<nav class="navbar navbar-expand-lg navbar-light fixed-top" style="
    background: #FFFFFF !important;
    border-bottom: 1px solid rgba(135, 206, 235, 0.3);
    box-shadow: 0 4px 20px rgba(65, 105, 225, 0.1);
    transition: none !important;
    z-index: 1030;
">
    <div class="container-fluid">
        <a class="navbar-brand fw-bold" href="<?= base_url('admin/dashboard') ?>" style="
            color: #1E3A8A !important;
            text-decoration: none;
            font-size: 1.5rem;
            font-weight: 700;
        ">
            <i class="bi bi-shield-lock me-2" style="color: #4169E1 !important;"></i>
            <span style="color: #4169E1 !important;">Admin Panel</span>
        </a>
        
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#adminNavbar" 
                aria-controls="adminNavbar" aria-expanded="false" aria-label="Toggle navigation" style="
            border: 1px solid rgba(65, 105, 225, 0.3) !important;
            border-radius: 8px;
            padding: 6px 10px;
        ">
            <span class="navbar-toggler-icon" style="
                background-image: url('data:image/svg+xml,%3csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 30 30\'%3e%3cpath stroke=\'rgba%2865, 105, 225, 0.8%29\' stroke-linecap=\'round\' stroke-miterlimit=\'10\' stroke-width=\'2\' d=\'M4 7h22M4 15h22M4 23h22\'/%3e%3c/svg%3e') !important;
            "></span>
        </button>
        
        <div class="collapse navbar-collapse" id="adminNavbar" style="
            background: #FFFFFF !important;
            border-radius: 12px !important;
            margin-top: 10px !important;
            padding: 15px !important;
            border: 1px solid rgba(135, 206, 235, 0.3) !important;
            box-shadow: 0 8px 32px rgba(65, 105, 225, 0.15) !important;
        ">
            <ul class="navbar-nav ms-auto align-items-center">
                <?php if (session()->get('user_role')): ?>
                    <li class="nav-item me-3">
                        <span class="d-flex align-items-center" style="
                            color: #1E3A8A !important;
                            font-weight: 500;
                            padding: 8px 16px;
                            background: rgba(65, 105, 225, 0.1);
                            border-radius: 20px;
                            border: 1px solid rgba(65, 105, 225, 0.2);
                        ">
                            <i class="bi bi-person-circle me-2" style="color: #4169E1;"></i>
                            <?= esc(session()->get('username')) ?>
                            <span style="
                                background: linear-gradient(135deg, #4169E1 0%, #87CEEB 100%);
                                color: white;
                                padding: 4px 12px;
                                border-radius: 12px;
                                font-size: 0.75rem;
                                font-weight: 600;
                                margin-left: 8px;
                            ">
                                <?= esc(str_replace('admin_', '', session()->get('user_role'))) ?>
                            </span>
                        </span>
                    </li>
                    <li class="nav-item me-2">
                        <a href="<?= base_url('/') ?>" target="_blank" style="
                            color: #4169E1 !important;
                            border: 2px solid #4169E1;
                            background: transparent;
                            padding: 8px 16px;
                            border-radius: 20px;
                            text-decoration: none;
                            font-weight: 500;
                            display: inline-flex;
                            align-items: center;
                            gap: 6px;
                            transition: all 0.3s ease;
                        " onmouseover="this.style.background='#4169E1'; this.style.color='white';" 
                           onmouseout="this.style.background='transparent'; this.style.color='#4169E1';">
                            <i class="bi bi-house"></i>
                            <span>Lihat Situs</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?= base_url('admin/logout') ?>" style="
                            background: linear-gradient(135deg, #EF4444 0%, #DC2626 100%);
                            color: white !important;
                            border: none;
                            border-radius: 20px;
                            font-weight: 600;
                            padding: 8px 16px;
                            text-decoration: none;
                            display: inline-flex;
                            align-items: center;
                            gap: 6px;
                            transition: all 0.3s ease;
                            box-shadow: 0 4px 15px rgba(239, 68, 68, 0.2);
                        " onmouseover="this.style.background='linear-gradient(135deg, #DC2626 0%, #EF4444 100%)'; this.style.transform='translateY(-2px)'; this.style.boxShadow='0 6px 20px rgba(239, 68, 68, 0.3)';" 
                           onmouseout="this.style.background='linear-gradient(135deg, #EF4444 0%, #DC2626 100%)'; this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 15px rgba(239, 68, 68, 0.2)';">
                            <i class="bi bi-box-arrow-right"></i>
                            <span>Logout</span>
                        </a>
                    </li>
                <?php else: ?>
                    <li class="nav-item">
                        <a href="<?= base_url('auth/login') ?>" style="
                            background: linear-gradient(135deg, #87CEEB 0%, #4169E1 100%) !important;
                            color: white !important;
                            border: none !important;
                            border-radius: 25px !important;
                            font-weight: 600 !important;
                            padding: 8px 20px;
                            text-decoration: none;
                            display: inline-block;
                            transition: all 0.3s ease;
                            box-shadow: 0 4px 15px rgba(65, 105, 225, 0.2);
                        " onmouseover="this.style.background='linear-gradient(135deg, #4169E1 0%, #87CEEB 100%)'; this.style.transform='translateY(-2px)'; this.style.boxShadow='0 6px 20px rgba(65, 105, 225, 0.3)';" 
                           onmouseout="this.style.background='linear-gradient(135deg, #87CEEB 0%, #4169E1 100%)'; this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 15px rgba(65, 105, 225, 0.2)';">
                            <i class="bi bi-box-arrow-in-right me-1"></i>
                            <span>Login</span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</nav>

<style>
/* Mobile navbar collapse styling */
@media (max-width: 991px) {
    .navbar-collapse {
        background: #FFFFFF !important;
        border-radius: 12px !important;
        margin-top: 10px !important;
        padding: 15px !important;
        border: 1px solid rgba(135, 206, 235, 0.3) !important;
        box-shadow: 0 8px 32px rgba(65, 105, 225, 0.15) !important;
    }
}

/* Override any external navbar styling that might interfere */
.navbar-light .navbar-nav .nav-link {
    color: #1E3A8A !important;
}

.navbar-light .navbar-brand {
    color: #1E3A8A !important;
}

.dropdown-toggle::after {
    border-top-color: #1E3A8A !important;
}

/* Force navbar to always be white - override any scroll classes */
.navbar,
.navbar.navbar-scrolled,
.admin-navbar,
.admin-navbar.navbar-scrolled {
    background: #FFFFFF !important;
    backdrop-filter: none !important;
    -webkit-backdrop-filter: none !important;
}

.navbar .navbar-brand,
.navbar.navbar-scrolled .navbar-brand,
.admin-navbar .navbar-brand,
.admin-navbar.navbar-scrolled .navbar-brand {
    color: #1E3A8A !important;
    text-shadow: none !important;
}

.navbar .nav-link,
.navbar.navbar-scrolled .nav-link,
.admin-navbar .nav-link,
.admin-navbar.navbar-scrolled .nav-link {
    color: #1E3A8A !important;
    text-shadow: none !important;
}
</style>


